******************************************************************************************************************
* Bootstrapped disability employment results for EHIS all ages
* Full BOOTSTRAP version - see explanation in master .do file
******************************************************************************************************************

*_____________________________________________________________________________________________________________________________________________________
*
* BOOTSTRAP COMMAND
*_____________________________________________________________________________________________________________________________________________________

capture program drop disempBS
program define disempBS, eclass
		syntax [varlist] [if], distypes(namelist) [subclustervar(name)] disvar(name) predictedvar(name) [fixedpredvar(name)] [wgvar(name)] irtvar(name) allirtvar(name) empvar(name) [controls(varlist fv)] [controls2(varlist fv)] // subclustervar is e.g. country-waves when the cluster var is countries - the varlist in the command is the higher-level grouping
		tokenize 		"`varlist'"
		local clustervar	"`1'"			
		dis _newline(20) "Next iteration - distypes are `distypes', predictedvar is `predictedvar', prediction var wo random element is `fixedpredvar', IRT var is `irtvar', disvar is `disvar', empvar is `empvar', regimevar is removed, clustervar is `clustervar'"
		
		****************************************************************************************************
		* PRELIMINARIES
		****************************************************************************************************
		// Creating the predicted disvar for each iteration - weights are constant, but random element needs to change in each botstrap replication 
		capture drop rand1 
		capture drop `predictedvar'
		gen rand1 = runiform()
		gen 	`predictedvar' = 0 if						 ~missing(p_predicted)
		replace `predictedvar' = 1 if p_predicted  > rand1 & ~missing(p_predicted)
		label var `predictedvar' "Disability IN BOOTSTRAP - regression-based measure using ${disvar}"

		
		****************************************************************************************************
		* ESTIMATION COMMANDS
		****************************************************************************************************
		foreach distype	in `distypes' {
			
			// Command for DIS EMP GAP
			logit `empvar' ib(1).``distype'var'##i.`clustervar' `controls' `controls2' `if' [pw=${pweight}]	// , vce(cluster mergeid)
				* Samples sizes  in the matrix n_`distype' (e.g. n_predicted), which is outputted from the command below
				matrix n_`distype' =  `e(N)' 									// [1,1] is obs, [1,2] is n(people) = `e(N_clust)'
					*levelsof `subclustervar'  if e(sample), local(sublist_`distype')		// numbers of subclusters (e.g. country-waves, or countries)
					levelsof `clustervar' if e(sample), local(wavelist_`distype')			// numbers of clusters (e.g. countries, regimes)
				matrix n_`distype' = n_`distype' , wordcount("`wavelist_`distype''")		// revises the matrix so that there's an extra col with number of country-wave clusters
				* Margins
				margins i.``distype'var' , over(`clustervar') 	nose noesample post at(${eurpop} ${controlsmeans}) 
				matrix reg_disemp_`distype' = e(b)

			// Command for DIS ITSELF
			logit 				``distype'var'    i.`clustervar' `controls' `controls2'  `if' [pw=${pweight}] // , vce(cluster mergeid)
				matrix  n_`distype' =  n_`distype', `e(N)'									// Sample size for dis, just as a check
				* Margins
				margins					, over(`clustervar') 	nose noesample post at(${eurpop} ${controlsmeans}) 
				matrix reg_dis_`distype' = e(b)
			
			// Labelling the matrix of sample sizes
			matrix colnames n_`distype' = "obs_emp_`distype'" "cw_emp_`distype'" "obs_dis_`distype'" // labelling the matrix
		/**/ }
		
		****************************************************************************************************
		* OUTPUTTING
		****************************************************************************************************
	
		// GENERATING NEW VECTORS OF RESULTS
		// The alternative of using ERETURN MATRIX would work, except that bootstrap won't allow you to bootstrap the whole vector of results.
		foreach distype	in `distypes' {	
			local i = 0
			foreach wave in `wavelist_`distype'' 	{
				local i = `i' + 1
				local out_colnames_`distype' = "`out_colnames_`distype''  `wave'.`clustervar'"
				// Disability
				if `i'==1	matrix disemp_`distype'	= 					reg_disemp_`distype'[1,colnumb(reg_disemp_`distype', "`wave'.`clustervar'#1.``distype'var'")]
				else		matrix disemp_`distype'	= disemp_`distype', reg_disemp_`distype'[1,colnumb(reg_disemp_`distype', "`wave'.`clustervar'#1.``distype'var'")]
				// Emp gap (value not vs. baseline) - note that you could also do e.g. 
				if `i'==1	matrix disgap_`distype'	= 					reg_disemp_`distype'[1,colnumb(reg_disemp_`distype', "`wave'.`clustervar'#0.``distype'var'")]    - reg_disemp_`distype'[1,colnumb(reg_disemp_`distype', "`wave'.`clustervar'#1.``distype'var'")]
				else 		matrix disgap_`distype'	= disgap_`distype', reg_disemp_`distype'[1,colnumb(reg_disemp_`distype', "`wave'.`clustervar'#0.``distype'var'")]    - reg_disemp_`distype'[1,colnumb(reg_disemp_`distype', "`wave'.`clustervar'#1.``distype'var'")]
				// Absolute disability level 
				if `i'==1	matrix dis_`distype'	= 				 	reg_dis_`distype'[1,colnumb(reg_dis_`distype', "`wave'.`clustervar'")]
				else 		matrix dis_`distype'	= dis_`distype', 	reg_dis_`distype'[1,colnumb(reg_dis_`distype', "`wave'.`clustervar'")]
				// PPFW (% prevented from working) calculations
				if `i'==1	matrix ppfw_`distype'	= 					dis_`distype'[1,`i'] * disgap_`distype'[1,`i']
				else 		matrix ppfw_`distype'	= ppfw_`distype', 	dis_`distype'[1,`i'] * disgap_`distype'[1,`i']
			/**/ }
		/**/ }

		* Labelling the columns
		local matlist "`matlist' dis disemp disgap ppfw"
		foreach distype	in `distypes' {			
			* The sample sizes are done first, as slightly different to dis disemp disgap ppfw
			matrix coleq	n_`distype' = n_`distype'
			* `fullmatlist' is a complete list of matrices to be posted just below
			if "`fullmatlist'"~=""	local fullmatlist "`fullmatlist', n_`distype'"		// This needs to be first - otherwise first results are duplicated!
			if "`fullmatlist'"==""	local fullmatlist "n_`distype'"
			* Now doing this for dis disemp disgap ppfw
			foreach output in `matlist' {
				matrix colnames `output'_`distype' = `out_colnames_`distype''
				matrix coleq	`output'_`distype' = `output'_`distype'
				local fullmatlist "`fullmatlist', `output'_`distype'" 	// A complete list of matrices to be posted just below
			/**/ }
		/**/ }
		
		// COMBINING VECTORS OF REGRESSION RESULTS INTO e(b)
		tempname bb
		matrix `bb' = `fullmatlist'
		matrix list `bb'
		ereturn post `bb' 
		ereturn local cmd="bootstrap"
end

